/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;

public class VWAssociationTargetType {
    private static final int MIN_TARGET_TYPE = 1;
    public static final int TARGET_TYPE_MAPNODE = 1;
    public static final int TARGET_TYPE_ROUTE = 2;
    private static final int MAX_TARGET_TYPE = 2;
    private static String[] LocalizedStrings = new String[]{new VWString("VW.api.VWAssociationTargetTypeMapNode", "MapNode").toString(), new VWString("VW.api.VWAssociationTargetTypeRoute", "Route").toString()};

    public static String _get_FILE_DATE() {
        return "$Date:   09 Sep 2008 14:10:30  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }

    public static String getLocalizedString(int targetType) throws VWException {
        if (!VWAssociationTargetType.isValid(targetType)) {
            throw new VWException("vw.api.VWAssociationTargetTypeBadInteger", "Integer form of the target type is invalid: {0}", String.valueOf(targetType));
        }
        return LocalizedStrings[targetType - 1];
    }

    public static boolean isValid(int targetType) {
        return targetType >= 1 && targetType <= 2;
    }

    protected static String typeToString(int targetType) throws VWException {
        switch (targetType) {
            case 1: {
                return "mapnode";
            }
            case 2: {
                return "route";
            }
        }
        throw new VWException("vw.api.VWAssociationTargetTypeBadInteger", "Integer form of the target type is invalid: {0}", String.valueOf(targetType));
    }

    protected static int stringToType(String targetType) throws VWException {
        if (targetType.equals("route")) {
            return 2;
        }
        if (targetType.equals("mapnode")) {
            return 1;
        }
        throw new VWException("vw.api.VWAssociationTargetTypeBadString", "String form of the target type is invalid: {0}", targetType);
    }
}

